#include <bits/stdc++.h>

#define f first
#define s second

using namespace std;

using ll = long long;
using ld = long double;
using ull = unsigned long long;

const int INF = 2e9;
const ll LL_INF = 2e18;
const ld EPS = 1e-7;

struct dsu {
    vector < int > p, sz;

    dsu(int s) {
        p.resize(s);
        iota(p.begin(), p.end(), 0);
        sz.resize(s, 1);
    }

    int get(int x) {
        if (p[x] != x)
            p[x] = get(p[x]);
        return p[x];
    }

    void unite(int a, int b) {
        a = get(a);
        b = get(b);

        if (a == b)
            return;

        if (sz[a] > sz[b])
            swap(a, b);

        p[a] = b;
        sz[b] += sz[a];
    }
};

struct Vector {
    ll x, y;

    Vector(): x(0), y(0){}
    Vector(ll x, ll y): x(x), y(y){}

    Vector operator+(Vector other) const {
        return {x + other.x, y + other.y};
    }


    Vector operator-(Vector other) const {
        return {x - other.x, y - other.y};
    }

    ll operator*(Vector other) const { /// cos
        return x * other.x + y * other.y;
    }

    ll operator%(Vector other) const { /// sin
        return x * other.y - other.x * y;
    }
};

struct seg {
    ll x1, y1, x2, y2;
//    seg(ll x1, ll y1, ll x2, ll y2): x1(x1), y1(y1), x2(x2), y2(y2){}
};

bool peresek(seg a, seg b) {
    Vector v1(b.x1 - a.x1, b.y1 - a.y1);
    Vector v2(b.x2 - a.x1, b.y2 - a.y1);
    Vector v(a.x2 - a.x1, a.y2 - a.y1);

//    cout << v.x << ' ' << v.y << "\n";
//    cout << v1.x << ' ' << v1.y << "\n";
//    cout << v2.x << ' ' << v2.y << "\n";

    ll q = v % v1;
    ll w = v % v2;

//    cout << q << ' ' << w << "\n";

    if (q == 0 && w == 0) {
        v1 = {a.x1 - b.x1, a.y1 - b.y1};
        v2 = {a.x2 - b.x1, a.y2 - b.y1};
        v = {b.x2 - b.x1, b.y2 - b.y1};

        q = v % v1;
        w = v % v2;

        if (q == 0 && w == 0) {
            if (a.x1 == a.x2 &&
                ((b.y1 <= max(a.y1, a.y2) && b.y1 >= min(a.y1, a.y2)) ||
                (b.y2 <= max(a.y1, a.y2) && b.y2 >= min(a.y1, a.y2)))) {
                    return true;

            }
            else if (a.x1 != a.x2 &&
                     (((b.x1 <= max(a.x1, a.x2) && b.x1 >= min(a.x1, a.x2)) ||
                (b.x2 <= max(a.x1, a.x2) && b.x2 >= min(a.x1, a.x2)))))
                return true;
        }
    }

    if ((q > 0 && w > 0) || (q < 0 && w < 0) || (q == w))
        return false;

    v1 = {a.x1 - b.x1, a.y1 - b.y1};
    v2 = {a.x2 - b.x1, a.y2 - b.y1};
    v = {b.x2 - b.x1, b.y2 - b.y1};
//
//    cout << "\n";
//    cout << v.x << ' ' << v.y << "\n";
//    cout << v1.x << ' ' << v1.y << "\n";
//    cout << v2.x << ' ' << v2.y << "\n";

    q = v % v1;
    w = v % v2;

//    cout << q << ' ' << w << "\n\n\n";

    if ((q > 0 && w > 0) || (q < 0 && w < 0) || (q == w))
        return false;

    return true;
}

void solve() {
    int n;
    cin >> n;

    vector < seg > a(n);

    for (int i = 0; i < n; ++i)
        cin >> a[i].x1 >> a[i].y1 >> a[i].x2 >> a[i].y2;

    dsu d(n);

    ll ans = 1;

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < i; ++j) {
            if (peresek(a[i], a[j])) {
                if (d.get(i) == d.get(j))
                    ++ans;
                else
                    d.unite(i, j);
            }
        }


//        cout << i + 1 << ' ' << ans << "\n";
    }

    cout << ans << "\n";
}

int main() {
//    freopen("input.txt", "r", stdin);
//    freopen("output.txt", "w", stdout);
    ios::sync_with_stdio(false), cin.tie(nullptr);
//    cout.tie(nullptr);
//    cout << setprecision(10) << fixed;

//    seg a, b;
//    a.x1 = 0;
//    a.y1 = 0;
//    a.x2 = 0;
//    a.y2 = 2;
//    b.x1 = 0;
//    b.y1 = 1;
//    b.x2 = 0;
//    b.y2 = 3;
//
//    cout << peresek(a, b);

    int tt = 1;
    cin >> tt;
    while (tt--) {
        solve();
    }
}
